/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.waila;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class SemiblockProvider {
    public static final ResourceLocation ID = PneumaticRegistry.RL("semiblock");

    public static class ComponentProvider
    implements IBlockComponentProvider {
        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            CompoundTag tag = blockAccessor.getServerData().m_128469_("semiBlocks");
            for (String name : tag.m_128431_()) {
                try {
                    int entityId = Integer.parseInt(name);
                    ISemiBlock entity = ISemiBlock.byTrackingId(blockAccessor.getLevel(), entityId);
                    if (!(entity instanceof AbstractSemiblockEntity) || entity instanceof IDirectionalSemiblock && ((IDirectionalSemiblock)((Object)entity)).getSide() != blockAccessor.getSide()) continue;
                    MutableComponent title = Component.m_237113_((String)"[").m_7220_(entity.getSemiblockDisplayName()).m_130946_("]").m_130940_(ChatFormatting.YELLOW);
                    iTooltip.add((Component)title);
                    entity.addTooltip(arg_0 -> ((ITooltip)iTooltip).add(arg_0), blockAccessor.getPlayer(), tag.m_128469_(name), blockAccessor.getPlayer().m_6144_());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }

        public ResourceLocation getUid() {
            return ID;
        }
    }

    public static class DataProvider
    implements IServerDataProvider<BlockEntity> {
        public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
            CompoundTag tag = new CompoundTag();
            SemiblockTracker.getInstance().getAllSemiblocks(level, blockEntity.m_58899_()).forEach(semiBlock -> {
                NonNullList<ItemStack> drops = semiBlock.getDrops();
                if (!drops.isEmpty()) {
                    tag.m_128365_(Integer.toString(semiBlock.getTrackingId()), (Tag)semiBlock.serializeNBT(new CompoundTag()));
                }
            });
            compoundTag.m_128365_("semiBlocks", (Tag)tag);
        }

        public ResourceLocation getUid() {
            return ID;
        }
    }
}

